<?php

namespace App\Http\Controllers\backend;

use Illuminate\Http\Request;

use App\Http\Requests\reqGm;
use App\Http\Controllers\Controller;

use App\Models\Gmaster;

use App\User;

class GmCtrl extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $this->data['title'] = 'Data master';
        $this->data['gmaster'] = Gmaster::orderBy('nip')->paginate(15);
        return view('backend.gmaster.index',$this->data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $this->data['title'] = 'Tambah Data master';
       
        $this->data['jabatan'] = ['Master'];
       
        return view('backend.gmaster.create',$this->data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(reqGm $request)
    {
        //
        $input = $request->all();
        $input['user_id'] = User::create(['username' => $input['nip'],'password' => bcrypt($input['nip']),'role' => 'gmaster'])->id;
        Gmaster::create($input);
        return redirect()->route('gmaster.index')->with('info','Master Berhasil Ditambahkan');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $this->data['title'] = 'Edit Data master';
        $this->data['gmaster'] = Gmaster::find($id);
       
        $this->data['jabatan'] = ['Master'];
       
        return view('backend.gmaster.edit',$this->data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $input = $request->except('_method','_token','mhs_id');
        $mhs = Gmaster::find($id);
        $mhs->update($input);
        $input['user_id'] = User::find($mhs->user_id)->update(['username' => $input['nip'],'password' => bcrypt($input['nip']),'role' => 'gmaster']);
        return redirect()->route('gmaster.index')->with('info','Data master berhasil diubah');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $nilai = Gmaster::find($id);
        $nilai->delete();
        return redirect()->route('gmaster.index')->with('info','Data master berhasil dihapus');
    }
}
